'Tower of Illinois
'made by bar1010 based on code by JirSoft

option default integer
'x positions for pillars 1, 2, 3, and 4
X1 =  162 'was 135 then 216, then 162
X2 =  483 'was 395 then 632, then 474
X3 =  804 'was 655 then 1048, then 786
X4 = 1125 'was 1098
'cr = &hFFF0000 'Red
cr = &hFFFFF00  'Yellow
'cy = &hFFFFF00 'Yellow
cy = &hF0000FF  'Blue
cw = &hFFFFFFF  'White
cb = RGB(NOTBLACK) : cc = &hF0000FF

tp = -1 'previous second counter, used for time display
frq = 192 'was 196, 'lowest frequency for music routine

'music in game, du$ is duration (1 is basic timing, 2 is twice so long, any number 1-9 can be used)
'mu$ is melody, a=G3, b=A3 etc., hz$ are frequencies of the notess
du$ = "112211112211112211221122111122111122112211221111112112211111121122111111211221111112"
mu$ = "ihfhiklkhifhefdbedabihfhiklkhifhefdbedabklmimlkiopmklmkpomlkhiklmimlkiopmklmkpomlkhi"
hz$ = "192,224,252,272,294,326,356,398,448,494,523,587,659,698,784,880,1038" 'was 988 at he end
j = 1 'pointer to current note
f1 = 1 : f2 = 3 'frequency divider for left and right channel
p5 = 364 'was 500, 'length of note with duration 1 (= 500ms), added delay to autoplay with LCTRL
rr = 250 : settick rr, z, 1 'start of playing interrupt routine, with rr = 0 is music switched off
xc = 640 : yc = 512 'coordinates of screen center
y = 819 'position of base for pillars, was 480
y4 = 358 : y1 = 462 'some pos constant reused more times, was 210, 271, then was 336, 434
y2 = 1023 'MM.VRES 'was 599
y3 = 1279 'MM.HRES 'was 799
n = 16 'game starts with autoplay of level 16 (highest) 'was 13
r 'turn music off for now

'text scroller
pt = 0 'relative Y position of current text
ps = 0 'pointer to current string (0-6)
dim jt$(6) = (" Made by bar1010 based", "on code from JirSoft", "Max. 48x100 characters", "", "", "", "")
jt$(3) = "January February March     "
jt$(4) = "April May June July        "
jt$(5) = "August September October   "
jt$(6) = "November December          "

dim d$(3) 'use 3 for 4 pillars, 'used as STACK for discs on pillars, first char ist the highest one (LEFT1 and MID2 is faster)
v = -1 'if v < 0, no disc is prepared to be put somewhere (all are on pillars), otherwise disc # for play next
w = 100 'autoplay wait-time (100ms)
'set MODE and prepare outline text for main banner
mode 15, 8 '1
text 640, 3, "TOWER of ILLINOIS", "CT", 5, 2, cy 'was 400, 2, was 5, 2
blit 2, 2, 2, 0, 1096, 64,, 4 'was 796, 64
blit 2, 2, 2, 4, 1098, 64,, 4 'was 798, 64
blit 2, 2, 0, 2, 1098, 64,, 4 'was 798, 64
blit 2, 2, 4, 2, 1098, 64,, 4 'was 798, 64
page write 1
cls
text 640, 3, "TOWER of ILLINOIS", "CT", 5, 2, cr 'was 400, 2, was 5, 2
page write 0
blit 0, 0, 0, 0, 1280, 1024, 1, 4 '1280 x 1024 is resolution

c$ = "0000" 'start counter
tn = 0 'when tn = 0, time is not running
settick 100, tm, 2 'start of time interrupt routine

'draw help texts
color rgb(cyan) : font 2
?@(4, y + 54) "Move ALL discs from pillar 1 to pillar 4 with the help of "; 'was 34
? "pillars 2 and 3. There is just one rule:"
color cr
?@(365) "You CAN'T put a BIGGER disc onto a SMALLER one." 'was 228
color cw
?@(0, 918) "KEYS: 1234 ... get/put disc from/to pillar"; 'was 540
?@(576) "Q ... QUIT game" : ?@(48); 'was 360, 48
? "  B   ... A solution (LCTRL=slow)";
box 0, y, 1279, 48, 1, cw, cc 'was 800, 30
?@(576) "N ... NEW game" 'was 360
?@(72) "+-  ... change number of discs"; 'was 48
?@(576) "M ... music ON/OFF"; 'was 360

u 'new game
x 'start autoplay
n = 1 : u 'after key restart game with level 1

'main program routine which checks keyboard
ke$ = "1234qnb+-m" 'all possible keys
f$ =  "emmmmquxhlr" 'routines for keys, e = EMPTY routine (when nothing was pressed)

do
  fk = instr(ke$, lcase$(inkey$)) 'get lower case key position, when no key, fk=0
                                 'fk is also reused for pillar number in move routine
  fn$ = mid$(f$, fk + 1, 1) 'get routine name, +1 makes 'e' routine for nothing pressed
  call fn$ 'routine call
loop

sub wk 'waiting for any key
  do while inkey$ = ""
  loop
end sub

sub h 'increase level up to 16
  inc n, n < 16 'smart way without IF..., was 13
  u 'new game
end sub

sub l 'decrease level down to 1
  inc n, -(n > 1) 'smart way without IF...
  u 'new game
end sub

sub tm 'time interrupt routine (100ms)
  jd 'call scroller
  j1 = (frq - 196) / 31 'height of audio display
  inc ti, tn 'increase tick (just when tn<>0)
  t2 = (ti \ 10) mod 60 'seconds of time
  blit 98, y + 2, 100, y + 2, 200, 27 'move audio display, was 98, 100, 200, 27
  rn = rn and (keydown(0) = 0 or ti < 10) 'if key is pressed and autoplay running (rn=1), stop it
  line 100, y + 27 - j1, 100, y + 27, 1, cw 'audio level of current note
  pixel 100, y + 27, cc 'remove this lower pixel (mainly needed when audio muted)
  t1 = ti \ 600 'minutes of time
  blit 0, 0, y3, 0, 1, 66 'move main banner
  blit 1, 0, 0, 0, y3, 66 '

  'when seconds were changed, display time
  if tp <> t2 then text 1266, y + 4, str$(t1, 2, 0, "0") + ":" + STR$(t2, 2, 0, "0"), "RT", 1, 2, cy, cc : tp = t2
end sub

sub q 'quit
  qq 'show effect
  box 349, 450, 582, 119, 0, cc, cc 'was 218, 265, 364, 70
  tx " Have a nice time ", "  with your CM2  "
  wk 'wait for key
  end
end sub

sub r 'music ON/OFF
  rr = 250 - rr
  frq = 196 'for audio display (no level)
  settick rr, z, 1
end sub

sub rt 'remove 'PRESS KEY TO START'
  box 0, 136, 1280, 85, 0, cb, cb 'was 80, 800, 50
end sub

sub m 'make move
  pg$ = chr$(asc(pg$) - 2 * (pg$ = "g" and d$(fk - 1) = ""))
  tn = 1 'start running time
  call pg$, fk - 1 'call 'g' (GET from pillar), 'p' (PUT to pillar) or 'e' (EMPTY)
  t 'test for finish
end sub

sub ds(px, py, ww, cc) 'draw disc on position px, py, wide ww
  if cc then box px, py, ww, 20, 1, cb, cb : exit sub 'when cc = 1 then erase it, was 20, 1
  box px, py, ww, 20, 1, cr, cy 'draw disc, was 20, 1
  'make some random points for better effect
  for ix = 2 to ww - 3
    for iy = 2 to 17 step 3
      if rnd > 0.9 then pixel px + ix, py + iy, cr
    next iy
  next ix
end sub

sub x 'autoplay
  u 'new game
  tn = 1 'start time run
  text 640, 104, " PRESS KEY TO START ", "CT", 4, 2, cb, cy 'was 400, 80
  rn = 1 'autplay is running
  a n, 0, 3, 1 'call autoplay routine, was 0, 2, 1

  if rn = 0 then 'if autoplay was stopped (in tm routine)
    rt  'remove text
    u   'start new game
    exit sub
  endif

  tn = 0 'autoplay was completed
  wk 'wait for key
  h ' mistake ?
  u ' new game
end sub

'1 to 2, 1 to 3, 2 to 1, 2 to 3, 2 to 4, 3 to 1, 3 to 2, 3 to 4 
sub a(nn, s, dd, hh) 'recursive Illinois solver, 'move nn discs from 's' to 'dd' over 'hh'
  if rn * nn = 1 then 'if running and nn = 1, make last move and finish
    g(s)  'get disc from source pillar
    pp    'delay
    p(dd) 'put disc to destination pillar
    pp    'delay
    exit sub
  endif

  if rn then 'if still not stopped, make recursion
    a nn - 1, s, hh, dd 'recursion
    g(s)  'get disc from source pillar
    pp    'delay
    p(dd) 'put disc to destination pillar
    pp    'delay
    a nn - 1, hh, dd, s 'recursion
  endif
end sub

'sub a(nn, s, dd, hh) 'recursive Illinois solver, 'move nn discs from 's' to 'dd' over 'hh'
'  if rn * nn = 1 then 'if running and nn = 1, make last move and finish
'    g(s)  'get disc from source pillar
'    pp    'delay
'    p(dd) 'put disc to destination pillar
'    pp    'delay
'    exit sub
'  endif

'  if rn then 'if still not stopped, make recursion
'    a nn - 1, s, hh, dd 'recursion
'    g(s)  'get disc from source pillar
'    pp    'delay
'    p(dd) 'put disc to destination pillar
'    pp    'delay
'    a nn - 1, hh, dd, s 'recursion
'  endif
'end sub

sub g(i) 'get disc from pillar i  (0-2 for pillars 1-3, 0-3 for pillars 1-4)
  v = asc(left$(d$(i), 1)) - 48 'what disc is on this pillar?, was 48
  o = len(d$(i)) 'how many discs on this pillar?
  xx = 167 - v * 10 'x position of the disc, was 140, 10
  yy = y - o * 20   'y position of the disc, was 20
  xs = 162 + i * 321 'pillar position, was 135, 260, then was 312

  ds xx + 475, 180, v * 20 'draw disc to temporary place, was 260, 130, 20, then was 312, 157, 20
  ds xx + i * 321, yy, v * 20, 1 'erase disc from pillar, was 260, 20, 1, then was 312
  box xs, yy, 10, 20, 1, cw, cc 'draw the pillar border (all 4), was 10, 20, 1
  box xs + 1, yy, 8, 20, 1, cc, cc 'and remove top and bottom one, was 8, 20, 1

  d$(i) = mid$(d$(i), 2) 'remove disc from stack
  pg$ = "p" 'now can be used PUT
end sub

sub t 'test for finishing of the level
  if len(d$(3)) < n then exit sub 'not enough discs on pillar 3, was d$(2)
  ts = 1 'finish
  for i = 1 to n
    ts = ts and ((asc(mid$(d$(3), i, 1)) - 48) = i) 'if not order, not finished yet, was 48, was d$(2)
  next i
  if ts then wi 'if finish, call WIN
end sub

sub p(i) 'put disc to pillar i (0 - 3 for pillars 1 - 4)
  o = len(d$(i)) + 1 'how many discs WILL be on this pillar?
  if o > 1 then 'some disc(s) already on piller, check for size
    if (asc(left$(d$(i), 1)) - 48) < v then 'bigger on smaller not allowed, was 48
      exit sub
    endif 'this is added because of multiline expansion
  endif 'this is added because of multiline expansion
  d$(i) = chr$(v + 48) + d$(i) 'add disc to stack, was 48

  'box x, y, width, erase, was v * 20, 1
  ds 640 - v * 10, 180, v * 20 + 2, 1 '*** erase temporary disc, was 400, 10, 130, 20, 1 ***, 130 = 13 * 10

  ds 167 - v * 10 + i * 321, y - o * 20, v * 20 'draw new one on pillar, was 140, 10, 260, 20, 20, 260 = 13 * 20
  v = 0 'nothing to GET
  pg$ = "g" 'so GET will be next
  inc mo 'increase move counter
  text 10, y + 4, str$(mo, 4, 0, "0"), "LT", 1, 2, cy, cc 'show new move counter, was 10, 4, 4, 1, 2
end sub

sub u 'NEW game
  ti = 0 'set time to 00:00
  tn = 0 'time is not running
  tp = -1 'previous seconds

  box 0, y4, 1280, y - y4, 0, cb, cb 'clear part of the screen, was 800

  erase d$ 'clear stack
  dim d$(3) 'use 2 for 3 items, 3 for 4 items, was d$(2)

  for i = 1 TO n 'and fill pillar 1
    v = n - i + 1
    p(0) 'PUT disc
  next i

  rt  'remove text
  box x1, y4, 10, y1 - n * 20, 1, cw, cc 'was 10, 20, 1
  box x2, y4, 10, y1, 1, cw, cc 'was 10
  box x3, y4, 10, y1, 1, cw, cc 'was 10
  box x4, y4, 10, y1, 1, cw, cc 'was 10

  mo = 0 'move counter to 0000
  text 9, y + 4, c$, "LT", 1, 2, cy, cc 'and redraw it

  text x1 + 5, 306, "1", "CT", 3,, cw, cb 'pillar numbers, was 180
  text x2 + 5, 306, "2", "CT", 3,, cw, cb 'was 180
  text x3 + 5, 306, "3", "CT", 3,, cw, cb 'was 180
  text x4 + 5, 306, "4", "CT", 3,, cw, cb 'was 180

  text 640, y + 4, " LEVEL " + STR$(n) + " ", "CT", 1, 2, cy, cc 'level = n, was 400
end sub

sub z 'MUSIC play routine, called in interrupt
  dur = p5 * val(mid$(du$, j, 1)) 'calculate duration
  frq = val(field$(hz$, asc(mid$(mu$, j, 1)) - 96, ",")) 'and frquency of current note
  settick dur, z, 1 'prepare for next note
  play tone frq / f1, frq / f2, dur 'play note, both channels are different
  inc j 'next note
  inc j, -len(mu$) * (j > len(mu$))) 'repeat from j = 1
end sub

sub pp 'PAUSE
  wp = w + p5 * (keydown(7) and 2) '100ms + 500ms when LCTRL is pressed
  w1 = timer 'wait in loop
  do while timer - w1 < wp
  loop
end sub

sub wi 'WIN (level finished)
  t9$ = "" 'prepare first row
  if mo < 2 ^ n then 'finished in least number of moves
    t9$ = "  OPTIMALLY  " 'show it
    box 429, 510, 422, 58, 0, cr, cr 'and make border, was 268, 300, 264, 34, 0
  endif 'this is added because of multiline expansion

  box 429, 450, 422, 63, 0, cr, cr : tx " You did it! ", t9$ 'show text, was 268, 265, 264, 37, 0
  tn = 0 'stop time
  wk 'wait for key
  rt 'remove wait text
  h 'increase level
end sub

sub qq 'effect for QUIT
  for i = 0 to y3 step 5
    i1 = 107 + i * 0.7
    line i, 107, y3 - i, y2, 1, cy
    line 0, i1, y3, i1, 1, cy
  next i
end sub

sub tx(t8$, t9$) 'text in 2 lines
  text xc, yc, t8$, "CB", 4, 2, cb, cy
  text xc, yc, t9$, "CT", 4, 2, cb, cy
end sub

sub jd 'SCROLL text
  box 750, y2 - pt, 528, 42, 0, cb, cb 'clear rest, was 547, 252, 25, 0
  text y3, y2 - pt, jt$(ps), "RT", 2,, cy 'draw current string' was RT
  inc pt, (pt < 60) 'increase position from 0 (bottom) to 50 (final pos), was 50
  inc ps, (pt = 60) * (ps < 7) 'if final position, take next string, was 50, 7
  inc pt, -60 * (pt = 60) 'if final position make position = 0, was -50, 50
  inc ps, -(ps > 6) * 7 'if string = 7 then should be 0, was 6, 7
end sub

sub e(i) 'EMPTY routine for no key pressed and also GET with no disc to GET
  pg$ = chr$(103 + 9 * (v > 0)) 'change from 'g' to 'p' when used in main loop
end sub

